unit Demoback;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Toggler, StdCtrls, Dtmisc, Custbtn;

type
  TBackgroundControls = class(TForm)
    ShadowButton1: TShadowButton;
    TiledBitmap1: TTiledBitmap;
    FountainFill1: TFountainFill;
    GroupBox1: TGroupBox;
    cycFrom: TODCycler;
    cycTo: TODCycler;
    procedure cycPaint(Sender: TObject);
    procedure cycClick(Sender: TObject);
  private
    { Private declarations }
    function GetCycleColor(val: Integer): TColor;
  public
    { Public declarations }
  end;

var
  BackgroundControls: TBackgroundControls;

implementation

{$R *.DFM}

function TBackgroundControls.GetCycleColor(val: Integer): TColor;
begin
  case val of
    0:  Result := clRed;
    1:  Result := clBlue;
    2:  Result := clWhite;
    3:  Result := clYellow;
    4:  Result := clAqua;
    5:  Result := clFuchsia;
    6:  Result := clBlack;
    7:  Result := clNavy;
  end;
end;

procedure TBackgroundControls.cycPaint(Sender: TObject);
var
  cyc: TODCycler;
  r: TRect;
  CCaption: array[0..255] of Char;
begin
  cyc := TODCycler(Sender);
  cyc.Canvas.Brush.Color := GetCycleColor(cyc.Value);
  cyc.Canvas.FillRect(cyc.ClientRect);
  cyc.Canvas.Font.Color := (cyc.Canvas.Brush.Color xor $00FFFFFF) and $00FFFFFF;
  r := cyc.ClientRect;
  Inc(r.left, 4);
  DrawText(cyc.Canvas.Handle, StrPCopy(CCaption, cyc.Caption), -1, r,
    DT_SINGLELINE or DT_VCENTER);
  if cyc.Focused then begin
    r := cyc.ClientRect;
    InflateRect(r, -2, -2);
    cyc.Canvas.DrawFocusRect(r);
  end;
end;

procedure TBackgroundControls.cycClick(Sender: TObject);
var
  cyc: TODCycler;
  col: TColor;
begin
  cyc := TODCycler(Sender);
  col := GetCycleColor(cyc.Value);
  if cyc.Value > 3 then
    FountainFill1.ToColor := col
  else
    FountainFill1.FromColor := col;
end;

end.
